(*********************************************************************************
* Copyright: Bernecker+Rainer
* Author:    Mikael Regard
* Created:   Sep 12, 2019/8:21 AM 
 *********************************************************************************
 * Description:

 * 
 *Input:

 *
 *
 * Output:

 *********************************************************************************)


FUNCTION_BLOCK PM_LoadMacroFromXml

	
	CASE XmlState OF
		XML_WAIT:
			Error := FALSE;
			IF(Load)THEN
				
				ErrorState := 0;
				ErrorInfo.FileIOError := FALSE;
				ErrorInfo.SyntaxError := FALSE;
				ErrorInfo.XmlError		:= FALSE;
				Error := FALSE;
				ErrorInfo.FileIOErrorInfo.FileIOErrorID := 0;
				ErrorInfo.FileIOErrorInfo.FileIOSysErrorID := 0;
				ErrorInfo.XmlErrorInfo.XmlErrorID := 0;
				ErrorInfo.SyntaxErrorInfo.CmdID := 0;
				ErrorInfo.SyntaxErrorInfo.Param := '';
				XmlState := XML_FILE_OPEN;
				NumberOfCommands := 0;
				ErrorInfo.CmdError := 0;
				ErrorInfo.CmdErrorInfo.CMDErrorID := 0;
				ErrorInfo.CmdErrorInfo.CmdID		:= 0;
			
			END_IF;		
			// Open XML File
		XML_FILE_OPEN:
			FileOpen_0.enable := TRUE;
			FileOpen_0.pDevice	:= ADR(FileDevice);
			FileOpen_0.pFile	:= ADR(FileName);
			FileOpen_0.mode		:= FILE_RW;
			FileOpen_0();
			
			IF(FileOpen_0.status = ERR_OK)THEN
				FileIdent := FileOpen_0.ident;
				XmlState := XML_FILE_READ;
			ELSIF(FileOpen_0.status <> ERR_FUB_BUSY)THEN
				ErrorState := 1;
				ErrorInfo.FileIOError 							:= TRUE;
				ErrorInfo.FileIOErrorInfo.FileIOErrorID 		:= FileOpen_0.status;
				ErrorInfo.FileIOErrorInfo.FileIOSysErrorID 		:= FileIoGetSysError();
				XmlState := XML_ERROR;		
			END_IF;
			
			
			
		
			// Read XML File into XmlData
			
		XML_FILE_READ:
			FileRead_0.enable 	:= TRUE;
			FileRead_0.ident 	:= FileIdent;
			FileRead_0.offset	:= 0;
			FileRead_0.pDest	:= ADR(XmlData[0]);
			FileRead_0.len		:= SIZEOF(XmlData);
			
			FileRead_0();		
			IF(FileRead_0.status = ERR_OK)THEN
				XmlState := XML_CREATE_MEMORY_READ;
			ELSE
				IF(FileRead_0.status <> ERR_FUB_BUSY)THEN
					ErrorState := 2;
					ErrorInfo.FileIOError 							:= TRUE;
					ErrorInfo.FileIOErrorInfo.FileIOErrorID 		:= FileOpen_0.status;
					ErrorInfo.FileIOErrorInfo.FileIOSysErrorID 		:= FileIoGetSysError();
					XmlState := XML_ERROR;	
				END_IF;
			END_IF;
			
			
			// Open XML Memory reader	
		XML_CREATE_MEMORY_READ:
			xmlCreateMemoryReader_0.enable 		:= TRUE;
			xmlCreateMemoryReader_0.pXmlMemory	:= ADR(XmlData);
			xmlCreateMemoryReader_0.memorySize	:= strlen(ADR(XmlData));
			xmlCreateMemoryReader_0();
			IF(xmlCreateMemoryReader_0.status = ERR_OK)THEN
				XmlIdent := xmlCreateMemoryReader_0.ident;
				XmlState := XML_READ_INIT;
			ELSIF(xmlCreateMemoryReader_0.status <> ERR_FUB_ENABLE_FALSE)THEN
				ErrorState 		:= 3;
				ErrorInfo.XmlError := TRUE;
				ErrorInfo.XmlErrorInfo.XmlErrorID := xmlCreateMemoryReader_0.status;
				XmlState 		:= XML_ERROR;
			END_IF;
		
			
			//Read Commands
		XML_READ_INIT:
			xmlReadNextNode_0.enable 	  	:= TRUE;
			xmlReadNextNode_0.ident		  	:= XmlIdent;
			xmlReadNextNode_0.forceRead	  	:= 0;
			xmlReadNextNode_0.skipSubtree 	:= 0;
			xmlReadNextNode_0.pName			:= ADR(ElementName);
			xmlReadNextNode_0.pValue		:= ADR(ElementValue);
			xmlReadNextNode_0.nameSize		:= SIZEOF(ElementName);
			xmlReadNextNode_0.valueSize		:= SIZEOF(ElementValue);
			xmlReadNextNode_0();
			
			xmlReadAttributeNr_0.pName		:= ADR(AttributeName);
			xmlReadAttributeNr_0.pValue		:= ADR(AttributeValue);
			xmlReadAttributeNr_0.nameSize	:= SIZEOF(AttributeName);
			xmlReadAttributeNr_0.valueSize	:= SIZEOF(AttributeValue);
			
			
			IF(xmlReadNextNode_0.status = ERR_OK)THEN
				IF(ElementName = 'Commands')THEN
					XmlState 	:= XML_READ_COMMAND;
				ELSE
					ErrorState := 4;
					ErrorInfo.SyntaxError := TRUE;
					ErrorInfo.SyntaxErrorInfo.CmdID := 0;
					ErrorInfo.SyntaxErrorInfo.Param := ElementName;
					XML_ERROR;
				END_IF;
			ELSIF(xmlReadNextNode_0.status <> ERR_FUB_ENABLE_FALSE)THEN
				ErrorState 	:= 4;
				ErrorInfo.XmlErrorInfo.XmlErrorID := xmlReadNextNode_0.status;
				ErrorInfo.XmlError := TRUE;
				XmlState 	:= XML_ERROR;
			END_IF;
		
			
		XML_READ_COMMAND:
//			TargetPosition.Angle := 0;
//			TargetPosition.ArcMode := 0;
//			TargetPosition.BufferOption := 0;
//			TargetPosition.CmdID := 0;
//			TargetPosition.Direction := 0;
//			TargetPosition.FinalSpeed := 0;
//			TargetPosition.MacroID := 0;
//			TargetPosition.MacroOption := 0;
//			TargetPosition.MaxAccel := 0;
//			TargetPosition.MaxSpeed := 0;
//			TargetPosition.NumOfXbot := 0;
//			TargetPosition.PathType := 0;
//			TargetPosition.PositionMode := 0;
//			TargetPosition.RX := 0;
//			TargetPosition.RY := 0;
//			TargetPosition.RZ := 0;
//			TargetPosition.Type := '';
//			TargetPosition.X := 0;
//			TargetPosition.Y := 0;
//			brsmemset(ADR(TargetPosition.XAsyncTarget),0,(ASYNC_MAX_XBOT+1)*4);
//			brsmemset(ADR(TargetPosition.YAsyncTarget),0,(ASYNC_MAX_XBOT+1)*4);
//			brsmemset(ADR(TargetPosition.XbotIDAsync[0]),0,(ASYNC_MAX_XBOT+1));
//			TargetPosition.XbotID	:= 0;
//			TargetPosition.Z	:= 0;
			
			xmlReadNextNode_0.ident := XmlIdent;
			xmlReadNextNode_0();
			IF(xmlReadNextNode_0.status = ERR_OK)THEN				
				IF(xmlReadNextNode_0.nodeType = xmlNODE_TYPE_ELEMENT)THEN		
					IF(ElementName = 'Command')THEN
						XmlState 	:= XML_READ_COMMAND_ID;
					ELSIF(ElementName = 'Parameter')THEN
						XmlState 	:= XML_READ_PARAMETER;
						AttrIndex := 0;
					ELSE
						ErrorInfo.SyntaxError := TRUE;
						ErrorInfo.SyntaxErrorInfo.CmdID := 0;
						ErrorInfo.SyntaxErrorInfo.Param := ElementName;
						XML_ERROR;			
					END_IF;
				ELSE
					XmlState := XML_READ_COMMAND;
				END_IF;
				
				
			ELSIF(xmlReadNextNode_0.status = xmlERR_NO_FURTHER_XML_NODE)THEN
				XmlState := XML_STOP_READ;
			ELSIF(xmlReadNextNode_0.status <> ERR_FUB_ENABLE_FALSE)THEN
				ErrorState 		:= 5;
				ErrorInfo.XmlError := TRUE;
				ErrorInfo.XmlErrorInfo.XmlErrorID := xmlReadNextNode_0.status;
				XmlState		:= XML_ERROR;
			END_IF;
		
		XML_READ_COMMAND_ID:
			xmlReadAttributeNr_0.enable	:= TRUE;
			xmlReadAttributeNr_0.index	:= 0; // Read first ID:
			xmlReadAttributeNr_0.ident	:= XmlIdent;
			xmlReadAttributeNr_0();
			IF(xmlReadAttributeNr_0.status = ERR_OK)THEN
				IF(AttributeName = 'id')THEN
					TargetPosition.CmdID := STRING_TO_UINT(AttributeValue);
					XmlState := XML_READ_COMMAND;
				ELSE
					ErrorInfo.SyntaxError := TRUE;
					ErrorInfo.SyntaxErrorInfo.CmdID := 0;
					ErrorInfo.SyntaxErrorInfo.Param := AttributeName;
					XmlState := XML_ERROR;
					ErrorState := 6;
				END_IF;
			ELSIF(xmlReadAttributeNr_0.status <> ERR_FUB_ENABLE_FALSE)THEN	
				ErrorInfo.XmlError := TRUE;
				ErrorInfo.XmlErrorInfo.XmlErrorID := xmlReadAttributeNr_0.status;
				XmlState 		:= XML_ERROR;
				ErrorState 		:= 6;
				
			END_IF;
					
		XML_READ_PARAMETER:		
			xmlReadAttributeNr_0.enable 	:= TRUE;
			xmlReadAttributeNr_0.ident		:= XmlIdent;
			xmlReadAttributeNr_0.index		:= AttrIndex;
			xmlReadAttributeNr_0();				
			IF(xmlReadAttributeNr_0.status = ERR_OK)THEN
				ReadMacroStatus := ReadMacroParam(ADR(TargetPosition),ADR(WaitUntil), AttributeValue, AttributeName);
				IF(ReadMacroStatus = 0)THEN
					AttrIndex := AttrIndex+1;
					IF(AttrIndex >= xmlReadNextNode_0.attributeCount)THEN
						XmlState := XML_MOVE_CMD;
						IF(MacroID > 0)THEN
							TargetPosition.MacroID := MacroID;
						END_IF;
						NumberOfCommands := NumberOfCommands +1;
					ELSE
						XmlState := XML_READ_PARAMETER;
					END_IF;
				ELSE
					XmlState 		:= XML_ERROR;
					ErrorInfo.SyntaxError := TRUE;
					ErrorInfo.SyntaxErrorInfo.CmdID := TargetPosition.CmdID;
					ErrorInfo.SyntaxErrorInfo.Param := AttributeName;
					ErrorState 		:= 7;
				END_IF;
					
			ELSIF(xmlReadAttributeNr_0.status <> ERR_FUB_ENABLE_FALSE)THEN
				XmlState 		:= XML_ERROR;
				ErrorInfo.XmlError := TRUE;
				ErrorInfo.XmlErrorInfo.XmlErrorID := xmlReadAttributeNr_0.status;
				ErrorState 		:= 7;		
			END_IF;
					
		XML_MOVE_CMD:
			IF(TargetPosition.Type = 'LinMove')THEN
				XmlState := XML_LINEAR_MOTION;
			ELSIF(TargetPosition.Type = 'ArcMove')THEN
				XmlState := XML_ARC_MOTION;
			ELSIF(TargetPosition.Type = 'ShortAxMove')THEN
				XmlState := XML_SHORT_AXIS_MOTION;
			ELSIF(TargetPosition.Type = 'EditMacro')THEN
				XmlState := XML_EDIT_MACRO;
			ELSIF(TargetPosition.Type = 'RunMacro')THEN
				XmlState := XML_RUN_MACRO;
			ELSIF(TargetPosition.Type = 'WaitUntil')THEN
				XmlState := XML_WAIT_UNTIL;
			END_IF;
				
			//			
			//			IF(NOT(pMacroXmlCtrl.Cmd.ReadCommand))THEN
			//				XmlState := XML_READ_COMMAND;
			//			END_IF;
		
		XML_LINEAR_MOTION:
			PM_LinearMotion_0.CmdLabel 			:= TargetPosition.CmdLabel;
			PM_LinearMotion_0.FinalSpeed 		:= TargetPosition.FinalSpeed;
			PM_LinearMotion_0.MaxAccel			:= TargetPosition.MaxAccel;
			PM_LinearMotion_0.MaxSpeed			:= TargetPosition.MaxSpeed;
			PM_LinearMotion_0.MsgFrame  		:= MsgFrame;
			PM_LinearMotion_0.ReadFrame			:= ReadFrame;
			PM_LinearMotion_0.PathType 			:= TargetPosition.PathType;
			PM_LinearMotion_0.TargetX 			:= TargetPosition.X;
			PM_LinearMotion_0.TargetY 			:= TargetPosition.Y;
			PM_LinearMotion_0.PositionMode 		:= TargetPosition.PositionMode;
			PM_LinearMotion_0.XbotID 			:= TargetPosition.XbotID;
			PM_LinearMotion_0.Execute := TRUE;
			
			IF(PM_LinearMotion_0.Done)THEN
				PM_LinearMotion_0.Execute := FALSE;
				ErrorCount := 0;
				XmlState := XML_READ_COMMAND;
			ELSIF(PM_LinearMotion_0.Error)THEN
				PM_LinearMotion_0.Execute := FALSE;
				ErrorCount := ErrorCount +1;
				IF(ErrorCount >= 20)THEN
					ErrorInfo.CmdError := TRUE;
					ErrorInfo.CmdErrorInfo.CMDErrorID := PM_LinearMotion_0.ErrorID;
					ErrorInfo.CmdErrorInfo.CmdID		:= TargetPosition.CmdID;
					XmlState := XML_ERROR;
				END_IF;
			END_IF;
			TargetPosition.CmdLabel := 0;
			PM_LinearMotion_0();
				
			
		XML_ARC_MOTION:
			PM_ArcMotion_0.CmdLabel 		:= TargetPosition.CmdLabel;
			PM_ArcMotion_0.Direction 		:= TargetPosition.Direction;
			PM_ArcMotion_0.ArcType 			:= TargetPosition.ArcType;
			PM_ArcMotion_0.ArcMode			:= TargetPosition.ArcMode;
			PM_ArcMotion_0.FinalTanSpeed 	:= TargetPosition.FinalSpeed;
			PM_ArcMotion_0.MaxAccel			:= TargetPosition.MaxAccel;
			PM_ArcMotion_0.MaxTanSpeed		:= TargetPosition.MaxSpeed;
			
			PM_ArcMotion_0.MsgFrame 		:= MsgFrame;
			PM_ArcMotion_0.ReadFrame		:= ReadFrame;
			
			PM_ArcMotion_0.PositionMode 	:= TargetPosition.PositionMode;
			PM_ArcMotion_0.Radius			:= TargetPosition.Angle;
			PM_ArcMotion_0.TargetX 			:= TargetPosition.X;
			PM_ArcMotion_0.TargetY			:= TargetPosition.Y;
			PM_ArcMotion_0.XbotID			:= TargetPosition.XbotID;
			
			PM_ArcMotion_0.Execute 			:= TRUE;
			IF(PM_ArcMotion_0.Done)THEN
				PM_ArcMotion_0.Execute := FALSE;
				ErrorCount := 0;
				XmlState := XML_READ_COMMAND;
			ELSIF(PM_ArcMotion_0.Error)THEN
				PM_ArcMotion_0.Execute := FALSE;
				ErrorCount := ErrorCount +1;
				IF(ErrorCount >= 20)THEN
					ErrorInfo.CmdError := TRUE;
					ErrorInfo.CmdErrorInfo.CMDErrorID := PM_ArcMotion_0.ErrorID;
					ErrorInfo.CmdErrorInfo.CmdID		:= TargetPosition.CmdID;
					XmlState := XML_ERROR;
				END_IF;
			END_IF;
			TargetPosition.CmdLabel := 0;
			PM_ArcMotion_0();
			
		XML_SHORT_AXIS_MOTION:
			PM_ShortAxisMotion_0.XbotID 		:= TargetPosition.XbotID;
			PM_ShortAxisMotion_0.PositionMode	:= TargetPosition.PositionMode;
			PM_ShortAxisMotion_0.SpeedRX		:= TargetPosition.MaxSpeed;
			PM_ShortAxisMotion_0.SpeedRY		:= TargetPosition.MaxSpeed;
			PM_ShortAxisMotion_0.SpeedRZ		:= TargetPosition.MaxSpeed;
			PM_ShortAxisMotion_0.SpeedZ			:= TargetPosition.MaxSpeed;
			PM_ShortAxisMotion_0.TargetRX		:= TargetPosition.RX;
			PM_ShortAxisMotion_0.TargetRY		:= TargetPosition.RY;
			PM_ShortAxisMotion_0.TargetRZ		:= TargetPosition.RZ;
			PM_ShortAxisMotion_0.TargetZ		:= TargetPosition.Z;
			PM_ShortAxisMotion_0.CmdLabel		:= TargetPosition.CmdLabel;
			PM_ShortAxisMotion_0.MsgFrame		:= MsgFrame;
			PM_ShortAxisMotion_0.ReadFrame		:= ReadFrame;
			PM_ShortAxisMotion_0.Execute		:= TRUE;
			IF(PM_ShortAxisMotion_0.Done)THEN
				PM_ShortAxisMotion_0.Execute := FALSE;
				ErrorCount := 0;
				XmlState := XML_READ_COMMAND;
			ELSIF(PM_ShortAxisMotion_0.Error)THEN
				PM_ShortAxisMotion_0.Execute := FALSE;
				ErrorCount := ErrorCount+1;
				IF(ErrorCount >= 20)THEN
					ErrorInfo.CmdError := TRUE;
					ErrorInfo.CmdErrorInfo.CMDErrorID := PM_ShortAxisMotion_0.ErrorID;
					ErrorInfo.CmdErrorInfo.CmdID		:= TargetPosition.CmdID;
					XmlState			:= XML_ERROR;
				END_IF;
			END_IF;
			TargetPosition.CmdLabel := 0;
			PM_ShortAxisMotion_0();
			
		XML_WAIT_UNTIL:
			PM_WaitUntil_0.CmdLabel			:= TargetPosition.CmdLabel;
			PM_WaitUntil_0.DigitalID		:= WaitUntil.DigitalID;
			PM_WaitUntil_0.DisplacementTrigger	:= WaitUntil.DisplacementTrigger;
			PM_WaitUntil_0.MsgFrame			:= MsgFrame;
			PM_WaitUntil_0.PosFactorA		:= WaitUntil.PosFactorA;
			PM_WaitUntil_0.PosFactorB		:= WaitUntil.PosFactorB;
			PM_WaitUntil_0.ReadFrame		:= ReadFrame;
			PM_WaitUntil_0.TriggerCmdLabel	:= WaitUntil.TriggerCmdLabel;
			PM_WaitUntil_0.TriggerType		:= WaitUntil.TriggerType;
			PM_WaitUntil_0.TriggerXbotID	:= WaitUntil.TriggerXbotID;
			PM_WaitUntil_0.WaitMode			:= WaitUntil.WaitMode;
			PM_WaitUntil_0.TimeDelay		:= WaitUntil.TimeDelay;
			PM_WaitUntil_0.XbotID			:= TargetPosition.XbotID;
			PM_WaitUntil_0.Execute			:= TRUE;			
			IF(PM_WaitUntil_0.Done)THEN
				PM_WaitUntil_0.Execute		:= FALSE;
				XmlState := XML_READ_COMMAND;
			ELSIF(PM_WaitUntil_0.Error)THEN
				PM_WaitUntil_0.Execute := FALSE;
				ErrorCount := ErrorCount+1;
				IF(ErrorCount >= 20)THEN
					ErrorInfo.CmdError := TRUE;
					ErrorInfo.CmdErrorInfo.CMDErrorID := PM_ArcMotion_0.ErrorID;
					ErrorInfo.CmdErrorInfo.CmdID		:= TargetPosition.CmdID;
					XmlState := XML_ERROR;
				END_IF;
			END_IF;
			TargetPosition.CmdLabel := 0;
			PM_WaitUntil_0();
		XML_EDIT_MACRO:
			PM_EditMacro_0.MacroID 		:= TargetPosition.MacroID;
			PM_EditMacro_0.MacroOption	:= TargetPosition.MacroOption;
			PM_EditMacro_0.MsgFrame		:= MsgFrame;
			PM_EditMacro_0.ReadFrame	:= ReadFrame;
			PM_EditMacro_0.Execute		:= TRUE;
			IF(PM_EditMacro_0.Done)THEN
				PM_EditMacro_0.Execute := FALSE;
				ErrorCount := 0;
				XmlState := XML_READ_COMMAND;
			ELSIF(PM_EditMacro_0.Error)THEN
				PM_EditMacro_0.Execute := FALSE;
				ErrorCount := ErrorCount+1;
				IF(TargetPosition.MacroOption = 2 AND PM_EditMacro_0.ErrorID = PM_ERR_WRONG_MACROSTATE)THEN
					PM_EditMacro_0.Execute := FALSE;
					XmlState := XML_READ_COMMAND;
				ELSIF(ErrorCount >= 20)THEN
					PM_EditMacro_0.Execute := FALSE;
					ErrorInfo.CmdError := TRUE;
					ErrorInfo.CmdErrorInfo.CMDErrorID := PM_EditMacro_0.ErrorID;
					ErrorInfo.CmdErrorInfo.CmdID		:= TargetPosition.CmdID;
					XmlState := XML_ERROR;
				END_IF;
			END_IF;
			TargetPosition.CmdLabel := 0;
			PM_EditMacro_0();
			
		XML_RUN_MACRO:
			PM_RunMacro_0.CmdLabelOption 	:= 0;
			PM_RunMacro_0.MacroID			:= TargetPosition.MacroID;
			PM_RunMacro_0.XbotID			:= TargetPosition.XbotID;
			PM_RunMacro_0.MsgFrame			:= MsgFrame;
			PM_RunMacro_0.ReadFrame			:= ReadFrame;
			PM_RunMacro_0.Execute			:= TRUE;
			IF(PM_RunMacro_0.Done)THEN
				PM_RunMacro_0.Execute		:= FALSE;
				ErrorCount := 0;
				XmlState := XML_READ_COMMAND;	
			ELSIF(PM_RunMacro_0.Error)THEN
				ErrorCount := ErrorCount +1;
				PM_RunMacro_0.Execute		:= FALSE;	
				IF((PM_RunMacro_0.ErrorID = PM_ERR_WRONG_MACROSTATE))THEN
					XmlState := XML_READ_COMMAND;
				ELSIF(ErrorCount >= 20)THEN			
					ErrorInfo.CmdError := TRUE;
					ErrorInfo.CmdErrorInfo.CMDErrorID := PM_RunMacro_0.ErrorID;
					ErrorInfo.CmdErrorInfo.CmdID		:= TargetPosition.CmdID;
					XmlState := XML_ERROR;
				END_IF;
			END_IF;
			PM_RunMacro_0();
		
			
			
			
		XML_STOP_READ:
			xmlCloseMemoryReader_0.enable 	:= TRUE;
			xmlCloseMemoryReader_0.ident	:= XmlIdent;
			xmlCloseMemoryReader_0();
			IF(xmlCloseMemoryReader_0.status = ERR_OK)THEN
				xmlCloseMemoryReader_0.enable := FALSE;
				XmlState := XML_FILE_CLOSE;
			ELSIF(xmlCloseMemoryReader_0.status <> ERR_FUB_ENABLE_FALSE)THEN
				ErrorState := 8;
				ErrorInfo.XmlError :=TRUE;
				ErrorInfo.XmlErrorInfo.XmlErrorID := xmlCloseMemoryReader_0.status;
				XmlState := XML_ERROR;;
			END_IF;
			
		XML_FILE_CLOSE:
			FileClose_0.enable 	:= TRUE;
			FileClose_0.ident	:= FileIdent;
			FileClose_0();
			IF(FileClose_0.status = 0)THEN
				IF(Error)THEN
					XmlState := XML_ERROR;
					FileClose_0.enable := FALSE;
					IsClosed := TRUE;
				ELSE
					XmlState := XML_DONE;
				END_IF;
				
			ELSIF(FileClose_0.status <> ERR_FUB_BUSY)THEN
				ErrorState := 8;
				ErrorInfo.FileIOError := TRUE;
				ErrorInfo.FileIOErrorInfo.FileIOSysErrorID := FileIoGetSysError();
				ErrorInfo.FileIOErrorInfo.FileIOErrorID := FileClose_0.status;				
				XmlState := XML_ERROR;
			END_IF;
		
		XML_DONE:
			IF(NOT(Load))THEN
				XmlState := XML_WAIT;
				ErrorCount := 0;
			END_IF;
			
		XML_ERROR:
			Error := TRUE;
			IF(NOT(IsClosed))THEN
				XmlState := XML_STOP_READ;
			ELSIF(NOT(Load))THEN
				XmlState := XML_WAIT;
				ErrorCount := 0;
				Error := FALSE;
				IsClosed := FALSE;
			END_IF;
			
		
	END_CASE;


	
	//Error := (XmlState = XML_ERROR);
	Done  := (XmlState = XML_DONE);
	Busy  := (XmlState <> XML_ERROR) AND (XmlState<> XML_WAIT);
	

	
	
END_FUNCTION_BLOCK



